/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.property.base.VWConfigTableRowItem;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWWebAppComboBox;
import java.awt.Dialog;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class VWConfigAttributesTableModel
extends AbstractTableModel {
    public static final int COLUMN_COUNT = 2;
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_VALUE = 1;
    protected static final int MAX_WEB_APP_ID = 999;
    protected static final int LAST_IBM_WEB_APP_INDEX = 10;
    protected Dialog m_parentDialog = null;
    protected String m_dialogTitle = null;
    protected Vector m_rowData = null;
    private VWAttributeInfo m_vwAttributeInfo = null;
    private String m_valueTitle = null;
    private String m_keyPrefix = null;
    private Vector m_deletedItemKeys = null;
    private boolean m_bHasChanged = false;

    public VWConfigAttributesTableModel(Dialog parentDialog, VWAttributeInfo vwAttributeInfo, String valueTitle, String keyPrefix) {
        this.m_parentDialog = parentDialog;
        this.m_vwAttributeInfo = vwAttributeInfo;
        this.m_valueTitle = valueTitle;
        this.m_keyPrefix = keyPrefix;
        this.init(this.getAttributes());
    }

    public VWConfigAttributesTableModel(Dialog parentDialog, Hashtable attributes, String valueTitle) {
        this.m_parentDialog = parentDialog;
        this.m_valueTitle = valueTitle;
        this.init(attributes);
    }

    public void addRow() {
        try {
            if (this.m_rowData == null) {
                this.m_rowData = new Vector();
            }
            for (int nIndex = 100; nIndex < 999; ++nIndex) {
                if (!this.isAvailableId(nIndex)) continue;
                VWConfigTableRowItem rowItem = new VWConfigTableRowItem(nIndex, "", 1);
                this.m_rowData.addElement(rowItem);
                int nRow = this.m_rowData.size() - 1;
                this.fireTableRowsInserted(nRow, nRow);
                this.m_bHasChanged = true;
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeRow(int nRow) {
        try {
            if (this.m_rowData == null || nRow < 10 || this.m_rowData.size() < nRow + 1) {
                return;
            }
            VWConfigTableRowItem rowItem = (VWConfigTableRowItem)this.m_rowData.elementAt(nRow);
            if (rowItem != null) {
                String key = this.getKeyFromId(rowItem.getId());
                if (key != null) {
                    if (this.m_deletedItemKeys == null) {
                        this.m_deletedItemKeys = new Vector();
                    }
                    this.m_deletedItemKeys.addElement(key);
                }
                this.m_rowData.removeElementAt(nRow);
                this.fireTableRowsDeleted(nRow, nRow);
                this.m_bHasChanged = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getMinimumRowCount() {
        return 10;
    }

    public boolean hasChanged() {
        return this.m_bHasChanged;
    }

    public boolean update() {
        try {
            int i;
            if (this.m_deletedItemKeys != null) {
                for (i = 0; i < this.m_deletedItemKeys.size(); ++i) {
                    String key = (String)this.m_deletedItemKeys.elementAt(i);
                    if (key == null) continue;
                    try {
                        this.m_vwAttributeInfo.deleteField(key);
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                }
            }
            if (this.m_rowData != null && this.m_rowData.size() > 0) {
                for (i = 0; i < this.m_rowData.size(); ++i) {
                    String key;
                    VWConfigTableRowItem rowItem = (VWConfigTableRowItem)this.m_rowData.elementAt(i);
                    if (rowItem == null || !rowItem.isModified() || (key = this.getKeyFromId(rowItem.getId())) == null) continue;
                    try {
                        String value = rowItem.getValue();
                        if (value != null && value.length() > 0) {
                            this.m_vwAttributeInfo.setFieldValue(key, value);
                            continue;
                        }
                        this.m_vwAttributeInfo.deleteField(key);
                        continue;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }

    public boolean verifySettings() {
        return true;
    }

    public void releaseResources() {
        this.m_parentDialog = null;
        this.m_dialogTitle = null;
        this.m_vwAttributeInfo = null;
        this.m_valueTitle = null;
        this.m_keyPrefix = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        if (this.m_deletedItemKeys != null) {
            this.m_deletedItemKeys.removeAllElements();
            this.m_deletedItemKeys = null;
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumn) {
        switch (nColumn) {
            case 0: {
                return VWResource.WebApplication;
            }
            case 1: {
                return this.m_valueTitle;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null) {
                return null;
            }
            VWConfigTableRowItem rowItem = (VWConfigTableRowItem)this.m_rowData.elementAt(nRowIndex);
            if (rowItem == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 0: {
                    return VWWebAppComboBox.getWebAppNameFromId(rowItem.getId());
                }
                case 1: {
                    return rowItem.getValue();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRow, int nColumn) {
        switch (nColumn) {
            case 0: {
                return nRow > 9;
            }
        }
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (this.m_rowData == null || !(aValue instanceof String)) {
                return;
            }
            VWConfigTableRowItem rowItem = (VWConfigTableRowItem)this.m_rowData.elementAt(nRowIndex);
            if (rowItem == null) {
                return;
            }
            String strValue = ((String)aValue).trim();
            switch (nColumnIndex) {
                case 0: {
                    int nId = Integer.parseInt(strValue);
                    if (nId == rowItem.getId()) {
                        return;
                    }
                    if (nId < 100 || nId > 999) {
                        JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.InvalidWebAppId.toString(strValue, String.valueOf(nRowIndex + 1)), this.m_dialogTitle, 2);
                        break;
                    }
                    if (!this.isAvailableId(nId)) {
                        JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.WebApplicationIdInUse.toString(strValue), this.m_dialogTitle, 2);
                        break;
                    }
                    rowItem.setId(nId);
                    this.m_bHasChanged = true;
                    break;
                }
                case 1: {
                    String validValue = this.getValidValue(strValue);
                    if (validValue == null) break;
                    rowItem.setValue(validValue);
                    this.m_bHasChanged = true;
                    break;
                }
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.m_parentDialog, VWResource.InvalidNumberFormat.toString((String)aValue, String.valueOf(nRowIndex + 1)), this.m_dialogTitle, 2);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected String getValidValue(String value) {
        return value;
    }

    protected Hashtable getAttributes() {
        Hashtable<Integer, String> attributes = new Hashtable<Integer, String>(999);
        try {
            String[] names = this.m_vwAttributeInfo.getAttributeNames();
            if (names != null) {
                for (int nIndex = 0; nIndex < names.length; ++nIndex) {
                    int nId;
                    if (!names[nIndex].startsWith(this.m_keyPrefix) || (nId = this.getIdFromKey(names[nIndex])) == -1) continue;
                    String value = (String)this.m_vwAttributeInfo.getFieldValue(names[nIndex]);
                    attributes.put(new Integer(nId), value);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return attributes;
    }

    private void init(Hashtable attributes) {
        try {
            Enumeration keys;
            this.m_rowData = new Vector();
            this.m_dialogTitle = VWIDMBaseFactory.instance().getVWString(4).toString();
            VWConfigTableRowItem wpItem = new VWConfigTableRowItem(1, null, 0);
            this.m_rowData.addElement(wpItem);
            VWConfigTableRowItem wpXtItem = new VWConfigTableRowItem(7, null, 0);
            this.m_rowData.addElement(wpXtItem);
            VWConfigTableRowItem wwItem = new VWConfigTableRowItem(2, null, 0);
            this.m_rowData.addElement(wwItem);
            VWConfigTableRowItem ocItem = new VWConfigTableRowItem(3, null, 0);
            this.m_rowData.addElement(ocItem);
            VWConfigTableRowItem collabItem = new VWConfigTableRowItem(4, null, 0);
            this.m_rowData.addElement(collabItem);
            VWConfigTableRowItem wcmItem = new VWConfigTableRowItem(5, null, 0);
            this.m_rowData.addElement(wcmItem);
            VWConfigTableRowItem rmItem = new VWConfigTableRowItem(6, null, 0);
            this.m_rowData.addElement(rmItem);
            VWConfigTableRowItem lmItem = new VWConfigTableRowItem(8, null, 0);
            this.m_rowData.addElement(lmItem);
            VWConfigTableRowItem bsItem = new VWConfigTableRowItem(9, null, 0);
            this.m_rowData.addElement(bsItem);
            VWConfigTableRowItem cnItem = new VWConfigTableRowItem(10, null, 0);
            this.m_rowData.addElement(cnItem);
            if (attributes != null && (keys = attributes.keys()) != null) {
                block14: while (keys.hasMoreElements()) {
                    Integer key = (Integer)keys.nextElement();
                    if (key == null) continue;
                    String value = (String)attributes.get(key);
                    switch (key) {
                        case 1: {
                            wpItem.setValue(value);
                            continue block14;
                        }
                        case 7: {
                            wpXtItem.setValue(value);
                            continue block14;
                        }
                        case 2: {
                            wwItem.setValue(value);
                            continue block14;
                        }
                        case 3: {
                            ocItem.setValue(value);
                            continue block14;
                        }
                        case 4: {
                            collabItem.setValue(value);
                            continue block14;
                        }
                        case 5: {
                            wcmItem.setValue(value);
                            continue block14;
                        }
                        case 6: {
                            rmItem.setValue(value);
                            continue block14;
                        }
                        case 8: {
                            lmItem.setValue(value);
                            continue block14;
                        }
                        case 9: {
                            bsItem.setValue(value);
                            continue block14;
                        }
                        case 10: {
                            cnItem.setValue(value);
                            continue block14;
                        }
                    }
                    VWConfigTableRowItem rowItem = new VWConfigTableRowItem(key, value, 0);
                    this.m_rowData.addElement(rowItem);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int getIdFromKey(String key) {
        try {
            StringTokenizer st;
            if (key != null && key.length() > 0 && (st = new StringTokenizer(key, ".")).hasMoreTokens()) {
                String token = st.nextToken();
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    return Integer.parseInt(token);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    private String getKeyFromId(int nId) {
        if (this.m_keyPrefix != null) {
            return this.m_keyPrefix + "." + Integer.toString(nId);
        }
        return null;
    }

    private boolean isAvailableId(int nId) {
        try {
            if (this.m_rowData != null && this.m_rowData.size() > 0) {
                for (int i = 0; i < this.m_rowData.size(); ++i) {
                    VWConfigTableRowItem rowItem = (VWConfigTableRowItem)this.m_rowData.elementAt(i);
                    if (rowItem == null || rowItem.getId() != nId) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
        return true;
    }
}

